/*******************************************
 *  Songzhan Chen created to draw and fit SED
 *  please send email to chensz@ihep.ac.cn for
 *  any problem
 *  2021-06-10
 * *****************************************/
TGraph * ReadSED(const char file[200],int ns, int nc, double size){
   ifstream file1;
   file1.open(file);
   char sTemp[200];
   TGraph *g;
   double energy,flux,err1,err2,x[200],ex[200],y[200],ey1[200],ey2[200];
   int i,n=0;
   file1.getline(sTemp,200);
   while(file1.good()){
        file1.getline(sTemp,200);
        i=sscanf(sTemp,"%lf %lf %lf %lf",&energy,&flux,&err1,&err2);
        if(i>1){
             if(flux/err1<1)continue;
            x[n]=energy; ex[n]=0;
            y[n]=flux/x[n];
            ey1[n]=err1/x[n];
            if(i>3)ey2[n]=err2/x[n];
            else ey2[n]=err1/x[n];
            n++;
        }
        if(n>200)printf("n>200\n");
   }
   file1.close();
   g=new TGraphAsymmErrors(n,x,y,ex,ex,ey1,ey2);
   g->SetMarkerStyle(ns);
   g->SetMarkerColor(nc);
   g->SetMarkerSize(size);
   g->SetLineColor(nc);
   g->SetLineWidth(2);

   return g;
}
void ReadSEDUpper(const char file[200],int nc){
   ifstream file1;
   file1.open(file);
   char sTemp[200];
   TLine *line;
   TArrow *a1;
   double energy,flux,err1,err2,x[200],ex[200],y[200],ey1[200],ey2[200];
   int i,n=0;
   file1.getline(sTemp,200);
   while(file1.good()){
        file1.getline(sTemp,200);
        i=sscanf(sTemp,"%lf %lf %lf %lf",&energy,&flux,&err1,&err2);
        if(i>1){
            if(flux/err1>1)continue;
            line=new TLine(pow(10,log10(energy)-0.1),err2/energy,pow(10,log10(energy)+0.1),err2/energy);
             line->SetLineColor(nc);
             line->SetLineWidth(2);
             line->Draw();
           a1=new TArrow(energy,err2/energy,energy,err2/energy*0.4,0.02,">");
              a1->SetLineColor(nc);
              a1->SetLineWidth(2);
              a1->Draw();            
        }
   }
   file1.close();
}
