/*******************************************
 *  Songzhan Chen created to draw and fit SED
 *  please send email to chensz@ihep.ac.cn for
 *  any problem
 *  ---------------------2021-06-10
 * *****************************************/
#include "ReadSED.h"
int CrabSED()
{
     TCanvas *c1=new TCanvas("c1","",800,600);
     c1->SetFillColor(10);
     c1->SetFrameFillColor(10);
     c1->SetLogy(1);
     c1->SetLogx(1);
     c1->SetFillStyle(0);
     gStyle->SetFillColor(10);
     gStyle->SetFrameFillColor(10);
     gStyle->SetStatColor(10);
     gStyle->SetStatTextColor(2);
     gStyle->SetPalette(1);
     gStyle->SetOptFit(0);
     TGraph *g[20];
     int i,j,k,n;
     TLatex *tex;
     double chi,x[100],y[100];
     char sTemp[300];
    x[0]=3.e-1;y[0]=3.e-9;
    x[1]=3.e3;y[1]=3.e-18;
    g[0]=new TGraph(2,x,y);

    g[1]=ReadSED("LHAASOSED.txt",20,4,1.4);

    g[0]->SetMarkerColor(10);
    g[0]->SetLineColor(10);
    g[0]->Draw("AP");
    g[1]->Draw("P");
    ReadSEDUpper("LHAASOSED.txt",4);

      TF1 *f3=new TF1("f3","[0]*pow(x/10.,[1]+[2]*log10(x/10.))*pow(x,1)");
      f3->SetParameters(2.e-14,-2.6,-0.2,1000);
      f3->SetLineColor(4);
      f3->SetLineStyle(1);
      f3->SetLineWidth(3);
      f3->SetParNames("J_{10TeV}","#alpha","b");
      g[1]->Fit(f3,"","",0.3,1600);

      g[0]->SetTitle(";Energy (TeV);#it{E}d#it{N}/d#it{E} (cm^{-2} s^{-1})");
      g[0]->GetYaxis()->CenterTitle(true);
      g[0]->GetYaxis()->SetTitleOffset(1.0);
      g[0]->GetXaxis()->SetTitleOffset(1.2);
      g[0]->GetXaxis()->CenterTitle(true);
      g[0]->GetYaxis()->SetTitleSize(0.05);

      tex=new TLatex(100,4.e-10,"Crab");
      tex->SetTextSize(0.06);
      tex->Draw();

      TLegend *lg=new TLegend(0.12,0.15,0.55,0.4);
        lg->AddEntry(g[1],"LHAASO","L:P");
        lg->AddEntry(f3,"Log-parabola model fit","L:F"); 
        lg->SetFillColor(10);
        lg->SetLineColor(10);
        lg->SetShadowColor(10);
        lg->Draw();
    //c1->Print("CrabSED.eps");
   return 0;
}

