/*******************************************
 *   Songzhan Chen created to draw crab Map
 *   please send email to chensz@ihep.ac.cn for
 *   any problem
 *   ---------------------2021-06-19
 ********************************************/
#include "ReadMap.h"
void CrabMap(){
  TCanvas *c1=new TCanvas("c1","The time offset effect",850,400);
  c1->SetFillColor(10);
  c1->SetFrameFillColor(kWhite);
  c1->SetTickx(1);
  c1->SetTicky(1); 
  gStyle->SetStatX(0.9);
  gStyle->SetStatY(0.9);
  gStyle->SetStatW(0.2);
  gStyle->SetStatH(0.16);
  gStyle->SetStatStyle(0);
  gStyle->SetPalette(1); 
  gStyle->SetTitleXOffset(1.0);
  gStyle->SetTitleYOffset(1.);  

  gStyle->SetTitleFillColor(kWhite);
  gStyle->SetFrameFillColor(kWhite);
  gStyle->SetOptStat(0);

  TFile *file[20]; TH2F *h2h[20];
  char sTemp[120];
  int i,j,k,NE;
  double Ra,Dec,R,w;
  w=1.2;
  Ra=83.63;Dec=22.02;
  double Res[2]={0.26, 0.13};
  TMarker *mark; 
  TEllipse *ellipse;
  TLatex *tex;
  c1->Divide(2,1);
   for(i=0;i<2;i++){
      c1->cd(i+1);
      if(i==0)NE=40;
      if(i==1)NE=400;
      h2h[i]=ReadMap("Map-pixel-list.txt",Ra,Dec,NE);
      h2h[i]->Draw("colz");
      if(i==1) h2h[i]->SetMinimum(-0.1);
      if(i==0){
          sprintf(sTemp,"40TeV<E<400TeV, S=%.1lf #sigma",h2h[i]->GetMaximum());
          tex=new TLatex(Ra-0.6*w,Dec+w*0.9,sTemp);
      }
      if(i==1){
          sprintf(sTemp,"400TeV<E, S=%.1lf #sigma",h2h[i]->GetMaximum());
          tex=new TLatex(Ra-0.4*w,Dec+w*0.9,sTemp);
      }
          tex->SetTextSize(0.04);
          tex->SetTextColor(10);
          tex->Draw();

      if(i==0) tex=new TLatex(Ra-w+0.03,Dec+w-0.16,"A");
      else tex=new TLatex(Ra-w+0.03,Dec+w-0.16,"B");
          tex->SetTextSize(0.06);
          tex->SetTextColor(10);
          tex->Draw();
      gPad->SetRightMargin(0.14);
      tex=new TLatex(Ra+w+0.4,Dec+0.4,"Significance (#sigma)");
          tex->SetTextSize(0.04);
          tex->SetTextColor(1);
          tex->SetTextAngle(90);
          tex->Draw();

      c1->Update();
      ellipse = new TEllipse(Ra+w-0.28*1.51,Dec-w+0.26*1.51,Res[i]*1.51/cos(Dec/57.3),Res[i]*1.51,0,360,0);
          ellipse->SetFillStyle(0); ellipse->SetLineWidth(2);
          ellipse->SetLineColor(10);
          ellipse->Draw();
      tex=new TLatex(Ra+w-0.28*1.51-0.11,Dec-w+0.26*1.51-0.02,"PSF");
          tex->SetTextSize(0.04);
          tex->SetTextColor(10);
          tex->Draw();


      tex=new TLatex(83.473241-0.2,22.173769+0.3,"0.9 PeV");
          tex->SetTextSize(0.05);
          tex->SetTextColor(71);
          tex->Draw();
      
      mark = new TMarker(83.473241, 22.173769,29);
          mark->SetMarkerSize(2.2);
          mark->SetMarkerColor(71);
          mark->Draw();

      tex=new TLatex(83.571+0.2,22.16-0.2,"1.1 PeV");
          tex->SetTextSize(0.05);
          tex->SetTextColor(3);
          tex->Draw();
      mark =new TMarker(83.571594, 22.163546,29);
          mark->SetMarkerSize(2.2);
          mark->SetMarkerColor(3);
          mark->Draw();

      h2h[i]->SetContour(100);
      printf("%lf\n",h2h[i]->GetMaximum());

      h2h[i]->GetYaxis()->CenterTitle(true);
      h2h[i]->GetXaxis()->CenterTitle(true);
      h2h[i]->GetYaxis()->SetLabelSize(0.03);
      h2h[i]->GetXaxis()->SetLabelSize(0.03);
      h2h[i]->GetYaxis()->SetTitleSize(0.04);
      h2h[i]->GetXaxis()->SetTitleSize(0.04);
      h2h[i]->GetYaxis()->SetTitleOffset(1.2);
      h2h[i]->GetXaxis()->SetTitleOffset(1.1);
      sprintf(sTemp,"; Ra (Deg); Dec (Deg)");
      h2h[i]->SetTitle(";Right ascension (degree) ;Declination (degree)");
  
     Int_t MyPalette[100];
     Double_t r[]    = {0., 0.0, 1.0, 1.0, 1.0};
     Double_t g[]    = {0., 0.0, 0.0, 1.0, 1.0};
     Double_t b[]    = {0., 1.0, 0.0, 0.0, 1.0};
     Double_t stop[] = {0., 0.45, 0.65, 0.85, 1.0};
     Int_t FI = TColor::CreateGradientColorTable(5, stop, r, g, b, 100);
     for (int i=0;i<100;i++){
         MyPalette[i] = FI+i;
     }
     gStyle->SetPalette(100, MyPalette);
     c1->Update();
   }
}
