#!/bin/bash 
 nshower=5555
 SD1=579
 SD2=925
 I=1
 P=1
 EL=1.e3
 EH=1.e7
while [ "$I" -lt 2001 ];
do
 B=./Gamma/
 corsika76400Linux_QGSII_gheisha <<EOF
RUNNR   $I                             run number
EVTNR   1                              number of first shower event
NSHOW   $nshower                       number of showers to generate
PRMPAR  $P                             particle type of prim. particle
ESLOPE  -2.0                           slope of primary energy spectrum
ERANGE  $EL  $EH                       energy range of primary particle
THETAP  0.  70.                        range of zenith angle (degree)
PHIP    0.  360.                       range of azimuth angle (degree)
SEED    $SD1   5   0                   seed for 1. random number sequence
SEED    $SD2   3   0                   seed for 2. random number sequence
OBSLEV  4424.E2                        observation level (in cm)
FIXHEI  0.  0                          first interaction height & target
FIXCHI  0.                             starting altitude (g/cm**2)
MAGNET  34.618  36.130                 magnetic field centr. LHAASO site
HADFLG  0  0  0  0  0  2               flags hadr.interact.&fragmentation
ECUTS   0.05  0.05  0.0005  0.0005     energy cuts for particles
MUADDI  F                              additional info for muons
MUMULT  T                              muon multiple scattering angle
ELMFLG  F   T                          em. interaction flags (NKG,EGS)
STEPFC  1.0                            mult. scattering step length fact.
RADNKG  200.E2                         outer radius for NKG lat.dens.distr.
ARRANG  0.                             rotation of array to north
QGSJET  T  0                           use QGSJET for high energy hadrons
QGSSIG  T                              use QGSJET hadronic cross sections
LONGI   T  10.  T  F                   longit.distr. & step size & fit & out
ECTMAP  1.E2                           cut on gamma factor for printout
MAXPRT  1                            max. number of printed events
DIRECT  $B                             output directory
DATBAS  T                              write .dbase file
USER    chensz                         user 
DEBUG   F  6  F  1000000               debug flag and log.unit for out
EXIT                                   terminates input
EOF
 I=`expr $I + 1`
 SD1=`expr $SD1 + 13 + $I`
 SD2=`expr $SD2 + 34 + $I`
done

