#!/usr/bin/env python
# coding: utf-8
import os
import random 
import numpy as np 
import yaml
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt
import astropy.io.fits as pyfits
import astropy.units as u
import astropy.constants as cont
import sys
#import naima
#sys.path.append('/Users/macbook/Desktop/SomeCode/radiation_mechanics/GAMERA/lib')
import gappa as gp
import astropy.units as u
def partical_spectrum(energy_p,power_law):
    energy_p =  energy_p*gp.TeV_to_erg
    power_law = power_law/gp.TeV_to_erg
    power_law_spectrum = np.array(list(zip(energy_p,power_law)))
    fu = gp.Utils()
    e_total_pl = fu.Integrate(list(zip(energy_p,power_law * energy_p)))
    #print(">%.1e TeV total energy is %s erg!"%(np.min(energy_p)/1.6,e_total_pl))
    return power_law_spectrum 

def power_law_fun(x, index, E_0):
    return (x/E_0)**-index
def creat_err(x):
    return x*0.4

xx_min_range = 1 
xx_max_range = 1318 

file_name="Sed_Peanut.txt"
data=np.genfromtxt(file_name,skip_header=0)
xx_data = data[:,0]
yy_data = data[:,1] # TeV/cm2/s
yy_dataerr1 = data[:,2]
yy_dataerr2 = data[:,3]
yy_end = creat_err(yy_data)
ts_value = data[:,4]

plt.figure(figsize=(8,6))
plt.xlabel('Energy (TeV)',fontsize=20)
plt.ylabel('$E^{2} dN/dE$ (TeV cm$^{-2}$ s$^{-1}$)',fontsize=20)
plt.ylim(np.min(yy_data)*0.2,np.max(yy_data)*3)
plt.xlim(10,1.4e3)
plt.xscale('log')#plt.semilogx()
plt.yscale('log')
plt.xticks(size=18)
plt.yticks(size=18)
sub = np.where(yy_dataerr1==0)[0]
if len(sub)>=1:
    plt.errorbar(xx_data[sub],yy_data[sub],
                yerr=([yy_data[sub]*0.4,yy_data[sub]*0]),marker='o',uplims=True ,elinewidth=2,capsize=5,color='k',ls='None',markersize=10)
sub = np.where(yy_dataerr1!=0)[0]
if len(sub)>=1:
    plt.errorbar(xx_data[sub],yy_data[sub],
                yerr=([yy_dataerr1[sub],yy_dataerr2[sub]]),marker='o',capsize=0,color='k',ls='None',markersize=10)


# Define Power-Law SED. 
f_fun = lambda E,N0,E0,gamma,Ec,beta: N0*(E/E0)**(-1*gamma)*np.exp(-(E/Ec)**beta)
ferr = lambda E,F,N0,N0err,E0,cov_gg,Ec,Ecerr: F*np.sqrt(N0err**2/N0**2+((np.log(E/E0))**2)*cov_gg+Ecerr**2*E**2/Ec**4)
norm_source = 8.10
norm_err = 0.9
norm_scale = 1e-17 
index_source = 1.95
index_err = 0.19
E0_source = 50 
Ec = 250 
Ec_err = 82

E = np.logspace(np.log10(xx_min_range),np.log10(1e4),300)
E_tev = E
### method 1
F = f_fun(E,norm_source*norm_scale,E0_source,index_source,Ec,1)
Ferr = ferr(E,F,norm_source*norm_scale,norm_err*norm_scale,E0_source,index_err**2,Ec,Ec_err)
y_mid = F*E**2
y_up = (F+Ferr)*E**2
y_low = (F-Ferr)*E**2

plt.fill_between(E_tev,y_up,y_low,where=y_low<=y_up,interpolate=True,facecolor='gray',label="PLEC",alpha=0.3)


#### fitting the data by eyes using pp.
ambient_density = 1 
distance = 3000 
norm = 1.30e47
index = 1.71
Ec = 1816 
E_0 = 1 
beta = 2 
energy_p = np.logspace(1,4,100)
flux_p = f_fun(energy_p,norm,E_0,index,Ec,beta)
power_law_spectrum_p = partical_spectrum(energy_p,flux_p)

#### leptonic 
t_cmb = 2.7; edens_cmb = 0.26 * gp.eV_to_erg #erg
norm = 3.22e45
index = 2.48
Ec = 772 
E_0 = 1 
beta = 2
energy_e = np.logspace(1,4,100)
flux_e = f_fun(energy_e,norm,E_0,index,Ec,beta)
power_law_spectrum_e = partical_spectrum(energy_e,flux_e)

fr = gp.Radiation()
fr.SetAmbientDensity(ambient_density)
fr.SetDistance(distance)
fr.SetProtons(power_law_spectrum_p)    

fr.AddThermalTargetPhotons(t_cmb,edens_cmb)
fr.SetElectrons(power_law_spectrum_e)

E_erg = np.logspace(np.log10(0.1*xx_min_range),np.log10(10*xx_max_range),100)*gp.TeV_to_erg
fr.CalculateDifferentialPhotonSpectrum(E_erg)


ic_sed = fr.GetICSED() 
ic_sed = np.array(ic_sed)
plt.plot(ic_sed[:,0],ic_sed[:,1]/gp.TeV_to_erg,color='r',label='IC-CMB',linewidth=4)

pp_sed = fr.GetPPSED() 
pp_sed = np.array(pp_sed)
plt.plot(pp_sed[:,0],pp_sed[:,1]/gp.TeV_to_erg,color='c',label='PP',linewidth=4,ls="--")


plt.legend(loc='upper right',fontsize=15,ncol=3)
plt.tight_layout()
plt.savefig('Sed_peanut.png')
plt.close()

